/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.acegisecurity;

import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.util.text.BasicTextEncryptor;
import org.jasypt.util.text.TextEncryptor;

public final class PBEPasswordEncoder
implements PasswordEncoder {
    private TextEncryptor textEncryptor = null;
    private PBEStringEncryptor pbeStringEncryptor = null;
    private Boolean useTextEncryptor = null;

    public void setTextEncryptor(TextEncryptor textEncryptor) {
        this.textEncryptor = textEncryptor;
        this.useTextEncryptor = Boolean.TRUE;
    }

    public void setPbeStringEncryptor(PBEStringEncryptor pbeStringEncryptor) {
        this.pbeStringEncryptor = pbeStringEncryptor;
        this.useTextEncryptor = Boolean.FALSE;
    }

    public String encodePassword(String rawPass, Object salt) {
        this.checkInitialization();
        if (this.useTextEncryptor.booleanValue()) {
            return this.textEncryptor.encrypt(rawPass);
        }
        return this.pbeStringEncryptor.encrypt(rawPass);
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        this.checkInitialization();
        String decPassword = null;
        decPassword = this.useTextEncryptor != false ? this.textEncryptor.decrypt(encPass) : this.pbeStringEncryptor.decrypt(encPass);
        if (decPassword == null || rawPass == null) {
            return decPassword == rawPass;
        }
        return decPassword.equals(rawPass);
    }

    private synchronized void checkInitialization() {
        if (this.useTextEncryptor == null) {
            this.textEncryptor = new BasicTextEncryptor();
            this.useTextEncryptor = Boolean.TRUE;
        } else if (this.useTextEncryptor.booleanValue()) {
            if (this.textEncryptor == null) {
                throw new EncryptionInitializationException("PBE Password encoder not initialized: text encryptor is null");
            }
        } else if (this.pbeStringEncryptor == null) {
            throw new EncryptionInitializationException("PBE Password encoder not initialized: PBE string encryptor is null");
        }
    }
}

