/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate.connectionprovider;

import java.util.Properties;
import org.hibernate.connection.C3P0ConnectionProvider;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.hibernate.encryptor.HibernatePBEEncryptorRegistry;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public final class EncryptedPasswordC3P0ConnectionProvider
extends C3P0ConnectionProvider {
    public void configure(Properties props) {
        String encryptorRegisteredName = props.getProperty("hibernate.connection.encryptor_registered_name");
        HibernatePBEEncryptorRegistry encryptorRegistry = HibernatePBEEncryptorRegistry.getInstance();
        PBEStringEncryptor encryptor = encryptorRegistry.getPBEStringEncryptor(encryptorRegisteredName);
        if (encryptor == null) {
            throw new EncryptionInitializationException("No string encryptor registered for hibernate with name \"" + encryptorRegisteredName + "\"");
        }
        String driver = props.getProperty("hibernate.connection.driver_class");
        String url = props.getProperty("hibernate.connection.url");
        String user = props.getProperty("hibernate.connection.username");
        String password = props.getProperty("hibernate.connection.password");
        if (PropertyValueEncryptionUtils.isEncryptedValue((String)driver)) {
            props.setProperty("hibernate.connection.driver_class", PropertyValueEncryptionUtils.decrypt((String)driver, (StringEncryptor)encryptor));
        }
        if (PropertyValueEncryptionUtils.isEncryptedValue((String)url)) {
            props.setProperty("hibernate.connection.url", PropertyValueEncryptionUtils.decrypt((String)url, (StringEncryptor)encryptor));
        }
        if (PropertyValueEncryptionUtils.isEncryptedValue((String)user)) {
            props.setProperty("hibernate.connection.username", PropertyValueEncryptionUtils.decrypt((String)user, (StringEncryptor)encryptor));
        }
        if (PropertyValueEncryptionUtils.isEncryptedValue((String)password)) {
            props.setProperty("hibernate.connection.password", PropertyValueEncryptionUtils.decrypt((String)password, (StringEncryptor)encryptor));
        }
        super.configure(props);
    }
}

